function libor = import_libor_bloomberg(file_name)
% --------------------------------------------------------------------------------------------------
% Import the historical 3m LIBOR time series
% --------------------------------------------------------------------------------------------------
% file_name         ... Excel file name with LIBOR time series
% --------------------------------------------------------------------------------------------------
% sample call: import_libor_bloomberg('c:/thesis/data/bloomberg/libor3m monthly.xls');
% --------------------------------------------------------------------------------------------------

% Import data
[num, txt] = xlsread(file_name, 1, 'A3:B1000');

% Put data into structure
libor = struct('dates', datenum(txt), 'price', num);